IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_EST_NF_ENT_MOVIMENTO_PROCESSAR') 
BEGIN
	DROP TRIGGER TRG_EST_NF_ENT_MOVIMENTO_PROCESSAR
END

IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_EST_NF_ENT_IT_MOVIMENTO_PROCESSAR') 
BEGIN
	DROP TRIGGER TRG_EST_NF_ENT_IT_MOVIMENTO_PROCESSAR
END
GO
/*
=======================================================================================
'Job.................:  
'Função..............: 
'Objetivo............: Inserir Data da Entrada na pendencia 
'Tabelas.............: 
'Dt Modificação......: 24/12/2020
'Modificação.........: Tag #A001 Ajustado pois a tabela EST_PROD_CPL_VD_PROC_PENDENTE não aceita DT_VD null.
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/

CREATE TRIGGER [DBO].[TRG_EST_NF_ENT_IT_MOVIMENTO_PROCESSAR] ON [DBO].[EST_NF_ENT_IT] FOR INSERT, UPDATE AS
IF NOT UPDATE(VLR_PRC_CUSTO) OR NOT UPDATE(VLR_CUSTO_MD)
BEGIN
	 IF NOT EXISTS
	 (
		 SELECT P.CD_FILIAL
		 FROM EST_PROD_CPL_VD_PROC_PENDENTE P
			  INNER JOIN INSERTED I ON P.CD_EMP = I.CD_EMP
									   AND P.CD_FILIAL = I.CD_FILIAL
									   AND P.CD_PROD = I.CD_PROD
									   AND P.DT_VD = I.DT_ENT
	 )
		 BEGIN
			 INSERT INTO EST_PROD_CPL_VD_PROC_PENDENTE
			 (CD_EMP
			, CD_FILIAL
			, CD_PROD
			, DT_VD
			, DT_CAD
			 )
				  SELECT DISTINCT
						   INSERTED.CD_EMP
						 , INSERTED.CD_FILIAL
						 , INSERTED.CD_PROD
						 ,ISNULL(INSERTED.DT_ENT, EST_NF_ENT.DT_ENT)
						 , GETDATE()
					FROM INSERTED
					     INNER JOIN EST_NF_ENT  ON INSERTED.CD_EMP      = EST_NF_ENT.CD_EMP    
											   AND INSERTED.CD_FILIAL = EST_NF_ENT.CD_FILIAL 
											   AND INSERTED.CD_NF     = EST_NF_ENT.CD_NF
				   WHERE EST_NF_ENT.CD_EMP = 1 ;
		 END;
END